import React, { useState, useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import { 
  Calendar, 
  Clock, 
  Video,
  Users, 
  Globe,
  Sparkles,
  TrendingUp,
  CheckCircle2,
  Award,
  Download,
  ArrowRight,
  Target,
  Briefcase,
  DollarSign,
  Zap,
  MessageSquare,
  FileText,
  Laptop,
  Star,
  BookOpen,
  Shield
} from 'lucide-react';
import CourseLeadForm from '../components/CourseLeadForm';
import Chatbot from '../components/Chatbot';

const WorkshopFreelancing = () => {
  const navigate = useNavigate();
  const [activeTab, setActiveTab] = useState('overview');

  const modules = [
    "Finding profitable freelance niches",
    "Creating multiple services using AI",
    "AI-assisted content writing & rewriting",
    "Designing social media posts for clients",
    "Resume writing & portfolio building",
    "Simple video editing & reels creation",
    "AI website building (no coding needed)",
    "Client communication using AI templates",
    "Proposal writing & pricing strategies",
    "Building a freelance portfolio in 1 day"
  ];

  const stats = [
    {
      icon: <Globe className="w-6 h-6" />,
      value: "2nd Largest",
      label: "India's global freelancing rank",
      color: "from-orange-500 to-amber-500"
    },
    {
      icon: <Zap className="w-6 h-6" />,
      value: "78%",
      label: "Freelancers use AI tools daily",
      color: "from-blue-500 to-cyan-500"
    },
    {
      icon: <TrendingUp className="w-6 h-6" />,
      value: "200-300%",
      label: "AI increases delivery speed",
      color: "from-green-500 to-emerald-500"
    },
    {
      icon: <DollarSign className="w-6 h-6" />,
      value: "2×",
      label: "More earnings with AI skills",
      color: "from-purple-500 to-pink-500"
    }
  ];

  const careerOutcomes = [
    { title: "AI Content Writer", icon: <FileText className="w-5 h-5" /> },
    { title: "AI Graphic Designer", icon: <Target className="w-5 h-5" /> },
    { title: "Social Media Manager", icon: <MessageSquare className="w-5 h-5" /> },
    { title: "Reels/Short-Form Video Editor", icon: <Zap className="w-5 h-5" /> },
    { title: "Resume/Portfolio Writer", icon: <Award className="w-5 h-5" /> },
    { title: "AI Virtual Assistant", icon: <Users className="w-5 h-5" /> },
    { title: "Web & Landing Page Designer", icon: <Laptop className="w-5 h-5" /> },
    { title: "Freelance Automation Specialist", icon: <Briefcase className="w-5 h-5" /> }
  ];

  const projects = [
    "Create 3 client-ready social media posts",
    "Write a fully AI-crafted professional resume",
    "Create a one-page website using AI",
    "Build 2 reels for a dummy brand",
    "Create a freelance gig listing (Upwork/Fiverr style)",
    "Build your Freelance Portfolio Folder"
  ];

  const tools = [
    "ChatGPT",
    "Canva AI",
    "InVideo / CapCut",
    "Framer AI / Durable AI",
    "Notion AI",
    "Jasper (content AI exposure)",
    "Resume.io",
    "Fiverr & Upwork analysis tools"
  ];

  const whoShouldJoin = [
    "Students starting side income",
    "Working professionals exploring freelancing",
    "Digital marketers, designers, editors",
    "Homemakers & part-time earners",
    "Creators & influencers",
    "Anyone who wants to start earning with AI"
  ];

  const faqs = [
    {
      q: "Can I start earning after this workshop?",
      a: "Yes — you'll build real samples you can immediately offer as services."
    },
    {
      q: "Do I need prior freelancing experience?",
      a: "No, we start from scratch."
    },
    {
      q: "Will I learn proposals & pricing?",
      a: "Yes, complete templates included."
    },
    {
      q: "Will you teach real platforms?",
      a: "Yes — Upwork, Fiverr, and other marketplaces."
    },
    {
      q: "Are recordings included?",
      a: "Yes, you get 30-day access."
    }
  ];

  const beforeAfterExamples = [
    {
      title: "Freelance Income Growth",
      before: {
        label: "Traditional Freelancing",
        value: "₹15K-20K/month",
        description: "Manual work, slow delivery, limited clients",
        stats: ["2-3 projects/month", "60+ hours/week", "Single skillset"]
      },
      after: {
        label: "With AI Tools",
        value: "₹50K-80K/month",
        description: "AI-automated workflows, 3× faster delivery",
        stats: ["8-10 projects/month", "25-30 hours/week", "Multiple services"]
      }
    },
    {
      title: "Project Delivery Speed",
      before: {
        label: "Manual Creation",
        description: "Blog post (1500 words): 4-5 hours",
        stats: ["Social media pack: 3 hours", "Resume design: 2 hours", "Landing page: 8 hours"]
      },
      after: {
        label: "AI-Powered Creation",
        description: "Blog post (1500 words): 45 minutes",
        stats: ["Social media pack: 30 mins", "Resume design: 20 mins", "Landing page: 1.5 hours"]
      }
    }
  ];

  return (
    <div className="min-h-screen bg-gradient-to-b from-orange-50 via-white to-amber-50">
      {/* Hero Section */}
      <section className="relative py-20 px-6 bg-gradient-to-br from-orange-600 via-amber-600 to-orange-700 text-white overflow-hidden">
        {/* Background Pattern */}
        <div className="absolute inset-0 opacity-10">
          <div className="absolute top-20 left-20 w-72 h-72 bg-white rounded-full blur-3xl"></div>
          <div className="absolute bottom-20 right-20 w-96 h-96 bg-yellow-300 rounded-full blur-3xl"></div>
        </div>

        <div className="container mx-auto max-w-6xl relative z-10">
          <button 
            onClick={() => navigate('/')}
            className="mb-8 flex items-center gap-2 text-white/90 hover:text-white transition-colors group"
          >
            <ArrowLeft className="w-5 h-5 group-hover:-translate-x-1 transition-transform" />
            <span className="font-medium">Back to Home</span>
          </button>

          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <div className="inline-block bg-white/20 backdrop-blur-sm px-4 py-2 rounded-full text-sm font-bold mb-6">
                🚀 Most Practical Income-Focused Workshop
              </div>
              <h1 className="text-5xl md:text-6xl font-bold mb-6 leading-tight">
                AI Tools for Freelancers & Side-Income Skills
              </h1>
              <p className="text-xl text-white/90 mb-8 leading-relaxed">
                Learn to automate 70% of your workload and build 10 in-demand AI-powered freelance services. Start earning immediately with ready-to-sell gigs and a professional portfolio.
              </p>

              <div className="grid grid-cols-2 gap-4 mb-8">
                <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-4 border border-white/20">
                  <div className="flex items-center gap-2 mb-2">
                    <Clock className="w-5 h-5" />
                    <span className="font-bold">Duration</span>
                  </div>
                  <p className="text-2xl font-bold">5 Hours</p>
                </div>
                <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-4 border border-white/20">
                  <div className="flex items-center gap-2 mb-2">
                    <Calendar className="w-5 h-5" />
                    <span className="font-bold">Next Cohort</span>
                  </div>
                  <p className="text-lg font-bold">8 Feb 2025</p>
                  <p className="text-sm text-white/80">(Saturday)</p>
                </div>
              </div>

              <div className="flex flex-wrap gap-4">
                <button 
                  onClick={() => document.getElementById('enrollment-form')?.scrollIntoView({ behavior: 'smooth' })}
                  className="bg-white text-orange-600 px-8 py-4 rounded-xl font-bold text-lg hover:bg-orange-50 transition-all shadow-xl hover:shadow-2xl hover:scale-105"
                >
                  Enroll Now - Early Bird Pricing
                </button>
                <button 
                  onClick={() => setActiveTab('details')}
                  className="bg-white/10 backdrop-blur-sm border-2 border-white/30 text-white px-8 py-4 rounded-xl font-bold text-lg hover:bg-white/20 transition-all"
                >
                  View Full Details
                </button>
              </div>
            </div>

            <div className="relative">
              <div className="relative rounded-3xl overflow-hidden shadow-2xl border-4 border-white/30">
                <img 
                  src="https://images.unsplash.com/photo-1522202176988-66273c2fd55f?w=800&h=600&fit=crop&q=80"
                  alt="Freelancers working with AI tools"
                  className="w-full h-[400px] object-cover"
                />
                <div className="absolute inset-0 bg-gradient-to-t from-orange-900/60 to-transparent"></div>
                <div className="absolute bottom-6 left-6 right-6">
                  <div className="bg-white/95 backdrop-blur-sm rounded-2xl p-4">
                    <p className="text-orange-600 font-bold text-lg">💼 Start Earning This Month</p>
                    <p className="text-gray-700 text-sm">Build portfolio samples you can sell immediately</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Industry Stats Section */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Why Freelancing with AI is the Future</h2>
            <p className="text-xl text-gray-600">The freelance market is booming — and AI gives you the competitive edge</p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6 mb-12">
            {stats.map((stat, index) => (
              <div key={index} className="bg-gradient-to-br from-gray-50 to-white rounded-2xl p-6 border-2 border-gray-100 hover:border-orange-200 hover:shadow-lg transition-all">
                <div className={`w-12 h-12 bg-gradient-to-br ${stat.color} rounded-xl flex items-center justify-center text-white mb-4`}>
                  {stat.icon}
                </div>
                <div className="text-3xl font-bold text-gray-900 mb-2">{stat.value}</div>
                <div className="text-sm text-gray-600">{stat.label}</div>
              </div>
            ))}
          </div>

          <div className="bg-gradient-to-r from-orange-100 to-amber-100 rounded-3xl p-8 border-2 border-orange-200">
            <div className="flex items-start gap-4">
              <div className="bg-orange-500 rounded-full p-3">
                <TrendingUp className="w-6 h-6 text-white" />
              </div>
              <div>
                <h3 className="text-2xl font-bold text-gray-900 mb-2">Global freelance market projected to reach</h3>
                <p className="text-4xl font-bold bg-gradient-to-r from-orange-600 to-amber-600 bg-clip-text text-transparent mb-2">
                  $4.2 Trillion by 2030
                </p>
                <p className="text-gray-700">AI-powered freelancers are leading this revolution with 2× higher earnings and 3× faster delivery times.</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Before & After Examples */}
      <section className="py-16 px-6 bg-gradient-to-b from-gray-50 to-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Real Impact on Your Freelance Career</h2>
            <p className="text-xl text-gray-600">See the transformation AI brings to freelancing</p>
          </div>

          <div className="space-y-8">
            {beforeAfterExamples.map((example, index) => (
              <div key={index} className="bg-white rounded-3xl overflow-hidden shadow-xl border-2 border-gray-100">
                <div className="bg-gradient-to-r from-orange-500 to-amber-500 text-white px-8 py-4">
                  <h3 className="text-2xl font-bold">{example.title}</h3>
                </div>
                <div className="grid md:grid-cols-2 divide-x divide-gray-200">
                  {/* Before */}
                  <div className="p-8 bg-gray-50">
                    <div className="flex items-center gap-2 mb-4">
                      <div className="bg-red-100 text-red-600 px-3 py-1 rounded-full text-sm font-bold">BEFORE</div>
                      <span className="text-gray-600 font-semibold">{example.before.label}</span>
                    </div>
                    {example.before.value && (
                      <p className="text-3xl font-bold text-gray-500 mb-3">{example.before.value}</p>
                    )}
                    <p className="text-gray-700 mb-4">{example.before.description}</p>
                    <ul className="space-y-2">
                      {example.before.stats.map((stat, i) => (
                        <li key={i} className="flex items-center gap-2 text-gray-600">
                          <div className="w-1.5 h-1.5 bg-gray-400 rounded-full"></div>
                          {stat}
                        </li>
                      ))}
                    </ul>
                  </div>

                  {/* After */}
                  <div className="p-8 bg-gradient-to-br from-orange-50 to-amber-50">
                    <div className="flex items-center gap-2 mb-4">
                      <div className="bg-green-100 text-green-600 px-3 py-1 rounded-full text-sm font-bold">AFTER</div>
                      <span className="text-gray-900 font-semibold">{example.after.label}</span>
                    </div>
                    {example.after.value && (
                      <p className="text-3xl font-bold bg-gradient-to-r from-orange-600 to-amber-600 bg-clip-text text-transparent mb-3">
                        {example.after.value}
                      </p>
                    )}
                    <p className="text-gray-800 font-medium mb-4">{example.after.description}</p>
                    <ul className="space-y-2">
                      {example.after.stats.map((stat, i) => (
                        <li key={i} className="flex items-center gap-2 text-gray-800">
                          <CheckCircle2 className="w-4 h-4 text-green-500" />
                          {stat}
                        </li>
                      ))}
                    </ul>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* What You Will Learn */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">What You Will Learn</h2>
            <p className="text-xl text-gray-600">10 comprehensive modules covering all aspects of AI-powered freelancing</p>
          </div>

          <div className="grid md:grid-cols-2 gap-6">
            {modules.map((module, index) => (
              <div key={index} className="flex items-start gap-4 bg-gradient-to-br from-orange-50 to-white rounded-2xl p-6 border-2 border-orange-100 hover:border-orange-300 hover:shadow-lg transition-all group">
                <div className="bg-gradient-to-br from-orange-500 to-amber-500 text-white rounded-xl w-10 h-10 flex items-center justify-center font-bold flex-shrink-0 group-hover:scale-110 transition-transform">
                  {index + 1}
                </div>
                <div>
                  <p className="text-gray-900 font-semibold text-lg">{module}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Visual Portfolio Examples */}
      <section className="py-16 px-6 bg-gradient-to-b from-gray-50 to-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Build Real Portfolio Samples</h2>
            <p className="text-xl text-gray-600">Walk away with client-ready work you can start selling immediately</p>
          </div>

          <div className="grid md:grid-cols-3 gap-6">
            {/* Portfolio Example 1 - Social Media Posts */}
            <div className="bg-white rounded-2xl overflow-hidden shadow-xl border-2 border-gray-100">
              <div className="h-48 bg-gradient-to-br from-pink-400 to-orange-400 relative">
                <img 
                  src="https://images.unsplash.com/photo-1611162616305-c69b3fa7fbe0?w=400&h=300&fit=crop&q=80"
                  alt="Social media designs"
                  className="w-full h-full object-cover mix-blend-overlay"
                />
              </div>
              <div className="p-6">
                <h3 className="text-xl font-bold text-gray-900 mb-2">Social Media Pack</h3>
                <p className="text-gray-600 mb-4">3 professional posts designed with Canva AI</p>
                <div className="flex items-center gap-2 text-sm text-orange-600 font-semibold">
                  <Zap className="w-4 h-4" />
                  Ready to sell for ₹500-800
                </div>
              </div>
            </div>

            {/* Portfolio Example 2 - Resume */}
            <div className="bg-white rounded-2xl overflow-hidden shadow-xl border-2 border-gray-100">
              <div className="h-48 bg-gradient-to-br from-blue-400 to-cyan-400 relative">
                <img 
                  src="https://images.unsplash.com/photo-1586281380349-632531db7ed4?w=400&h=300&fit=crop&q=80"
                  alt="Professional resume"
                  className="w-full h-full object-cover mix-blend-overlay"
                />
              </div>
              <div className="p-6">
                <h3 className="text-xl font-bold text-gray-900 mb-2">AI-Crafted Resume</h3>
                <p className="text-gray-600 mb-4">Professional resume created in 20 minutes</p>
                <div className="flex items-center gap-2 text-sm text-orange-600 font-semibold">
                  <Zap className="w-4 h-4" />
                  Ready to sell for ₹300-600
                </div>
              </div>
            </div>

            {/* Portfolio Example 3 - Website */}
            <div className="bg-white rounded-2xl overflow-hidden shadow-xl border-2 border-gray-100">
              <div className="h-48 bg-gradient-to-br from-purple-400 to-pink-400 relative">
                <img 
                  src="https://images.unsplash.com/photo-1467232004584-a241de8bcf5d?w=400&h=300&fit=crop&q=80"
                  alt="Website design"
                  className="w-full h-full object-cover mix-blend-overlay"
                />
              </div>
              <div className="p-6">
                <h3 className="text-xl font-bold text-gray-900 mb-2">Landing Page</h3>
                <p className="text-gray-600 mb-4">One-page website built with AI (no code)</p>
                <div className="flex items-center gap-2 text-sm text-orange-600 font-semibold">
                  <Zap className="w-4 h-4" />
                  Ready to sell for ₹2000-4000
                </div>
              </div>
            </div>
          </div>

          <div className="mt-8 bg-gradient-to-r from-orange-500 to-amber-500 rounded-3xl p-8 text-white text-center">
            <h3 className="text-3xl font-bold mb-4">💰 Potential Monthly Income</h3>
            <p className="text-6xl font-bold mb-2">₹50,000 - ₹80,000</p>
            <p className="text-xl text-white/90">By offering just 3-4 of these services on Upwork & Fiverr</p>
          </div>
        </div>
      </section>

      {/* Who Should Join */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Who Should Join</h2>
            <p className="text-xl text-gray-600">This workshop is perfect for anyone looking to earn using AI</p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            {whoShouldJoin.map((person, index) => (
              <div key={index} className="flex items-center gap-4 bg-gradient-to-br from-orange-50 to-white rounded-2xl p-6 border-2 border-orange-100 hover:border-orange-300 hover:shadow-lg transition-all">
                <CheckCircle2 className="w-6 h-6 text-orange-500 flex-shrink-0" />
                <p className="text-gray-800 font-semibold">{person}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Career Outcomes */}
      <section className="py-16 px-6 bg-gradient-to-b from-gray-50 to-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Career Outcomes</h2>
            <p className="text-xl text-gray-600">Start offering these in-demand services immediately</p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            {careerOutcomes.map((outcome, index) => (
              <div key={index} className="bg-white rounded-2xl p-6 border-2 border-gray-100 hover:border-orange-300 hover:shadow-xl transition-all group">
                <div className="bg-gradient-to-br from-orange-500 to-amber-500 text-white rounded-xl w-12 h-12 flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">
                  {outcome.icon}
                </div>
                <h3 className="text-lg font-bold text-gray-900">{outcome.title}</h3>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Hands-On Projects */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Hands-On Projects</h2>
            <p className="text-xl text-gray-600">Build your complete freelance portfolio in just 5 hours</p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            {projects.map((project, index) => (
              <div key={index} className="bg-gradient-to-br from-orange-50 to-amber-50 rounded-2xl p-6 border-2 border-orange-200 hover:shadow-lg transition-all">
                <div className="flex items-start gap-3">
                  <div className="bg-orange-500 text-white rounded-full w-8 h-8 flex items-center justify-center font-bold text-sm flex-shrink-0">
                    {index + 1}
                  </div>
                  <p className="text-gray-900 font-semibold pt-1">{project}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Tools You Will Use */}
      <section className="py-16 px-6 bg-gradient-to-b from-gray-50 to-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Tools You Will Master</h2>
            <p className="text-xl text-gray-600">Industry-standard AI tools used by top freelancers</p>
          </div>

          <div className="grid grid-cols-2 md:grid-cols-4 gap-6">
            {tools.map((tool, index) => (
              <div key={index} className="bg-white rounded-2xl p-6 border-2 border-gray-100 hover:border-orange-300 hover:shadow-lg transition-all text-center group">
                <div className="bg-gradient-to-br from-orange-100 to-amber-100 rounded-xl w-16 h-16 flex items-center justify-center mx-auto mb-3 group-hover:scale-110 transition-transform">
                  <Briefcase className="w-8 h-8 text-orange-600" />
                </div>
                <p className="font-bold text-gray-900">{tool}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* About Trainers */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-6xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">About the Trainers</h2>
          </div>

          <div className="bg-gradient-to-br from-orange-50 to-amber-50 rounded-3xl p-8 border-2 border-orange-200">
            <div className="flex flex-col md:flex-row items-center gap-8">
              <div className="flex-shrink-0">
                <img 
                  src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=300&h=300&fit=crop&q=80"
                  alt="Expert trainer"
                  className="w-48 h-48 rounded-full object-cover border-4 border-orange-300"
                />
              </div>
              <div>
                <div className="flex items-center gap-2 mb-4">
                  <Award className="w-6 h-6 text-orange-600" />
                  <span className="text-orange-600 font-bold">WorkshopLibrary-Certified Experts</span>
                </div>
                <p className="text-gray-700 text-lg mb-4 leading-relaxed">
                  This workshop is led by freelancers & AI productivity experts with <span className="font-bold text-orange-600">10+ years of experience</span> in:
                </p>
                <ul className="grid md:grid-cols-2 gap-3">
                  <li className="flex items-center gap-2 text-gray-700">
                    <CheckCircle2 className="w-5 h-5 text-orange-500" />
                    Freelance platforms (Upwork, Fiverr, Freelancer.com)
                  </li>
                  <li className="flex items-center gap-2 text-gray-700">
                    <CheckCircle2 className="w-5 h-5 text-orange-500" />
                    AI-assisted content & creative workflows
                  </li>
                  <li className="flex items-center gap-2 text-gray-700">
                    <CheckCircle2 className="w-5 h-5 text-orange-500" />
                    Client communication systems
                  </li>
                  <li className="flex items-center gap-2 text-gray-700">
                    <CheckCircle2 className="w-5 h-5 text-orange-500" />
                    Portfolio building & gig creation
                  </li>
                  <li className="flex items-center gap-2 text-gray-700">
                    <CheckCircle2 className="w-5 h-5 text-orange-500" />
                    Helping 5,000+ learners start freelance careers
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Certification */}
      <section className="py-16 px-6 bg-gradient-to-b from-gray-50 to-white">
        <div className="container mx-auto max-w-4xl">
          <div className="bg-gradient-to-br from-orange-500 to-amber-500 rounded-3xl p-12 text-white text-center shadow-2xl">
            <Award className="w-20 h-20 mx-auto mb-6" />
            <h2 className="text-4xl font-bold mb-4">Certification Included</h2>
            <div className="bg-white/20 backdrop-blur-sm rounded-2xl p-6 inline-block">
              <p className="text-2xl font-bold mb-2">🎓 AI Tools for Freelancers & Side-Income Skills Certificate</p>
              <p className="text-white/90">Issued by Workshop Library</p>
            </div>
            <p className="mt-6 text-xl text-white/90">
              Recognized by agencies & clients for foundational skill development
            </p>
          </div>
        </div>
      </section>

      {/* FAQs */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-4xl">
          <div className="text-center mb-12">
            <h2 className="text-4xl font-bold text-gray-900 mb-4">Frequently Asked Questions</h2>
          </div>

          <div className="space-y-4">
            {faqs.map((faq, index) => (
              <div key={index} className="bg-gradient-to-r from-orange-50 to-white rounded-2xl p-6 border-2 border-orange-100 hover:border-orange-300 transition-all">
                <h3 className="text-xl font-bold text-gray-900 mb-3 flex items-start gap-3">
                  <span className="text-orange-500">Q.</span>
                  {faq.q}
                </h3>
                <p className="text-gray-700 text-lg pl-8">{faq.a}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 px-6 bg-gradient-to-br from-orange-600 via-amber-600 to-orange-700 text-white">
        <div className="container mx-auto max-w-4xl text-center">
          <h2 className="text-5xl font-bold mb-6">Ready to Start Your Freelancing Journey?</h2>
          <p className="text-2xl text-white/90 mb-8">
            Join 5,000+ learners who've transformed their careers with AI-powered freelancing
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button 
              onClick={() => {
                navigate('/');
                setTimeout(() => {
                  document.getElementById('enrollment-form')?.scrollIntoView({ behavior: 'smooth' });
                }, 100);
              }}
              className="bg-white text-orange-600 px-10 py-5 rounded-xl font-bold text-xl hover:bg-orange-50 transition-all shadow-2xl hover:shadow-3xl hover:scale-105"
            >
              Enroll Now - Limited Seats
            </button>
            <button 
              onClick={() => navigate('/')}
              className="bg-white/10 backdrop-blur-sm border-2 border-white/30 text-white px-10 py-5 rounded-xl font-bold text-xl hover:bg-white/20 transition-all"
            >
              Explore Other Workshops
            </button>
          </div>
          
          <div className="mt-12 grid grid-cols-3 gap-6 max-w-2xl mx-auto">
            <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-4 border border-white/20">
              <p className="text-3xl font-bold mb-1">5 Hours</p>
              <p className="text-white/80 text-sm">Intensive Training</p>
            </div>
            <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-4 border border-white/20">
              <p className="text-3xl font-bold mb-1">10 Services</p>
              <p className="text-white/80 text-sm">To Offer Clients</p>
            </div>
            <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-4 border border-white/20">
              <p className="text-3xl font-bold mb-1">6 Projects</p>
              <p className="text-white/80 text-sm">Portfolio Ready</p>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
};

export default WorkshopFreelancing;
