import React, { useEffect } from 'react';
import { ArrowLeft } from 'lucide-react';
import { useNavigate } from 'react-router-dom';
import EnrollmentForm from '../components/EnrollmentForm';
import { trackPageView } from '../utils/analytics';

const EnrollmentPage = () => {
  const navigate = useNavigate();

  useEffect(() => {
    // Track page view when component mounts
    trackPageView('/enrollment', 'Enrollment - AI School for All');
  }, []);

  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 via-white to-indigo-50">
      {/* Header/Navigation */}
      <header className="bg-white shadow-sm sticky top-0 z-50">
        <div className="container mx-auto px-6 py-4">
          <div className="flex items-center justify-between">
            <button
              onClick={() => navigate('/')}
              className="flex items-center gap-2 text-blue-600 hover:text-blue-700 font-semibold transition-colors"
            >
              <ArrowLeft className="w-5 h-5" />
              Back to Home
            </button>
            <h1 className="text-xl font-bold text-gray-900">AI School for All</h1>
            <div className="w-24"></div> {/* Spacer for centering */}
          </div>
        </div>
      </header>

      {/* Hero Section */}
      <section className="py-12 px-6">
        <div className="container mx-auto max-w-4xl text-center">
          <h1 className="text-4xl md:text-5xl font-bold text-gray-900 mb-4">
            Start Your Journey in Digital Marketing
          </h1>
          <p className="text-xl text-gray-600 mb-2">
            Join thousands of students learning AI-powered marketing
          </p>
          <p className="text-lg text-blue-600 font-semibold">
            Limited seats available - Enroll now to secure your spot!
          </p>
        </div>
      </section>

      {/* Benefits Section */}
      <section className="py-8 px-6">
        <div className="container mx-auto max-w-4xl">
          <div className="grid md:grid-cols-3 gap-6 mb-12">
            <div className="bg-white rounded-xl p-6 shadow-md text-center">
              <div className="text-3xl mb-2">🎓</div>
              <h3 className="font-bold text-gray-900 mb-2">Expert-Led Training</h3>
              <p className="text-sm text-gray-600">Learn from industry professionals</p>
            </div>
            <div className="bg-white rounded-xl p-6 shadow-md text-center">
              <div className="text-3xl mb-2">📜</div>
              <h3 className="font-bold text-gray-900 mb-2">Global Certification</h3>
              <p className="text-sm text-gray-600">Exemplar Global certified program</p>
            </div>
            <div className="bg-white rounded-xl p-6 shadow-md text-center">
              <div className="text-3xl mb-2">💼</div>
              <h3 className="font-bold text-gray-900 mb-2">Career Growth</h3>
              <p className="text-sm text-gray-600">100% job placement support</p>
            </div>
          </div>
        </div>
      </section>

      {/* Enrollment Form Section */}
      <section className="py-8 px-6 pb-20">
        <div className="container mx-auto max-w-4xl">
          <EnrollmentForm />
        </div>
      </section>

      {/* Trust Indicators */}
      <section className="py-12 px-6 bg-white border-t">
        <div className="container mx-auto max-w-4xl">
          <div className="flex flex-wrap items-center justify-center gap-8 text-center">
            <div>
              <p className="text-3xl font-bold text-blue-600">30,000+</p>
              <p className="text-sm text-gray-600">Students Worldwide</p>
            </div>
            <div>
              <p className="text-3xl font-bold text-blue-600">40+</p>
              <p className="text-sm text-gray-600">Expert Instructors</p>
            </div>
            <div>
              <p className="text-3xl font-bold text-blue-600">4.8/5</p>
              <p className="text-sm text-gray-600">Student Rating</p>
            </div>
            <div>
              <p className="text-3xl font-bold text-blue-600">Since 2011</p>
              <p className="text-sm text-gray-600">Training Excellence</p>
            </div>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="py-6 px-6 bg-gray-900 text-white text-center">
        <p className="text-sm">© 2025 AI School for All. All rights reserved.</p>
        <p className="text-xs text-gray-400 mt-2">Powered by Workshop Library</p>
      </footer>
    </div>
  );
};

export default EnrollmentPage;
