import React, { useState, useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import { 
  CheckCircle2, Clock, Users, TrendingUp, Award, 
  Briefcase, Star, ArrowRight, Phone, Mail, 
  Calendar, DollarSign, Target, Zap, PlayCircle,
  Globe, BarChart3, Sparkles, X
} from 'lucide-react';
import { trackPageView, trackButtonClick } from '../utils/analytics';
import BookingForm from '../components/BookingForm';

const CSDGPMLandingPageNew = () => {
  const navigate = useNavigate();
  const [showBookingModal, setShowBookingModal] = useState(false);
  const [timeLeft, setTimeLeft] = useState({
    days: 0,
    hours: 0,
    minutes: 0,
    seconds: 0
  });

  useEffect(() => {
    trackPageView('/csdgpm-landing', 'CSDGPM Landing Page - Special Offer');

    // Countdown timer - Set to 7 days from now
    const targetDate = new Date();
    targetDate.setDate(targetDate.getDate() + 7);

    const timer = setInterval(() => {
      const now = new Date().getTime();
      const distance = targetDate.getTime() - now;

      setTimeLeft({
        days: Math.floor(distance / (1000 * 60 * 60 * 24)),
        hours: Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)),
        minutes: Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60)),
        seconds: Math.floor((distance % (1000 * 60)) / 1000)
      });
    }, 1000);

    return () => clearInterval(timer);
  }, []);

  const handleEnrollClick = (location) => {
    trackButtonClick('enroll_now', location);
    navigate('/enrollment?utm_source=landing&utm_medium=csdgpm&utm_campaign=special_offer');
  };

  const handleBookingClick = (location) => {
    trackButtonClick('book_slot', location);
    setShowBookingModal(true);
  };

  const testimonials = [
    { name: "Rajesh Kumar", role: "Digital Marketing Manager", company: "Tech Startup", rating: 5, quote: "This certification changed my career trajectory completely. Got 3 job offers within 2 months of completion!" },
    { name: "Priya Sharma", role: "Performance Marketing Lead", company: "E-commerce", rating: 5, quote: "The AI-powered marketing modules were game-changers. My campaigns now run 10x more efficiently." },
    { name: "Mohammed Al Zaabi", role: "Growth Marketing Specialist", company: "SaaS Company", rating: 5, quote: "From zero marketing knowledge to managing million-dollar budgets. This program made it possible!" }
  ];

  const stats = [
    { number: "30,000+", label: "Students Placed", icon: <Users className="w-8 h-8 text-blue-600" /> },
    { number: "95%", label: "Placement Rate", icon: <Target className="w-8 h-8 text-green-600" /> },
    { number: "500+", label: "Hiring Partners", icon: <Briefcase className="w-8 h-8 text-purple-600" /> },
    { number: "4.9/5", label: "Student Rating", icon: <Star className="w-8 h-8 text-yellow-600" /> }
  ];

  const forWhom = [
    { icon: "💼", title: "Career Switchers", desc: "Want to transition into high-paying marketing roles but don't know where to start" },
    { icon: "🎓", title: "Fresh Graduates", desc: "Looking to get placed in top companies with in-demand digital marketing skills" },
    { icon: "📈", title: "Business Owners", desc: "Want to generate leads without spending thousands on ads and agencies" },
    { icon: "🚀", title: "Marketing Professionals", desc: "Looking to upskill with AI-powered marketing and automation tools" },
    { icon: "💰", title: "Freelancers", desc: "Want to earn 6-figure income by offering digital marketing services" },
    { icon: "🎯", title: "Entrepreneurs", desc: "Need to master performance marketing to scale their business profitably" }
  ];

  const curriculum = [
    {
      day: "Module 1-2",
      title: "Digital Marketing Fundamentals & SEO Mastery",
      topics: [
        "Understanding the digital marketing landscape and career opportunities",
        "Consumer behavior online and buyer journey mapping",
        "Complete SEO: On-page, Technical, Off-page & Local SEO",
        "Keyword research mastery and competitor analysis",
        "Link building strategies that actually work in 2025"
      ]
    },
    {
      day: "Module 3-4",
      title: "Search Engine Marketing & Paid Advertising",
      topics: [
        "Google Ads mastery: Search, Display, Shopping & Video campaigns",
        "Advanced bidding strategies and budget optimization",
        "Creating high-converting ad copy and landing pages",
        "Facebook & Instagram Ads: Complete targeting & scaling guide",
        "LinkedIn Ads for B2B lead generation"
      ]
    },
    {
      day: "Module 5-6",
      title: "Social Media Marketing & Content Strategy",
      topics: [
        "Building brand presence across all major platforms",
        "Content calendar creation and viral content frameworks",
        "Influencer marketing and community management",
        "YouTube marketing and video content strategy",
        "Twitter/X and LinkedIn for thought leadership"
      ]
    },
    {
      day: "Module 7-8",
      title: "AI-Powered Marketing Automation & Analytics",
      topics: [
        "ChatGPT for marketing: Content creation at scale",
        "AI tools for design, copywriting, and video creation",
        "Marketing automation workflows using AI",
        "Google Analytics 4: Complete data analysis guide",
        "Building dashboards and measuring ROI accurately"
      ]
    }
  ];

  const tools = [
    "Google Ads", "Facebook Ads Manager", "ChatGPT", "Semrush", 
    "Google Analytics", "HubSpot", "Canva", "Mailchimp",
    "Hootsuite", "Ahrefs", "Buffer", "MidJourney"
  ];

  return (
    <div className="min-h-screen bg-white">
      {/* Scrolling Ticker Banner */}
      <div className="bg-gradient-to-r from-yellow-400 via-orange-500 to-red-500 text-gray-900 py-3 overflow-hidden">
        <div className="flex animate-scroll whitespace-nowrap">
          {[...Array(10)].map((_, i) => (
            <span key={i} className="inline-flex items-center mx-8 font-bold text-sm">
              ⭐ LIMITED PERIOD OFFER ⭐ FLAT 50% OFF
            </span>
          ))}
        </div>
      </div>

      {/* Fixed Sticky CTA */}
      <div className="fixed top-20 right-4 z-50 hidden lg:block">
        <button
          onClick={() => handleEnrollClick('sticky_cta')}
          className="bg-gradient-to-r from-yellow-400 to-orange-500 hover:from-yellow-500 hover:to-orange-600 text-gray-900 px-6 py-3 rounded-full font-black text-base shadow-2xl hover:scale-105 transition-all flex items-center gap-2"
        >
          Enroll Now
          <ArrowRight className="w-5 h-5" />
        </button>
      </div>

      {/* Hero Section - White Background, Clean */}
      <section className="bg-white py-12 px-6">
        <div className="container mx-auto max-w-6xl">
          {/* Exemplar Logo */}
          <div className="flex justify-center mb-8">
            <div className="bg-gray-50 px-6 py-3 rounded-xl border border-gray-200 flex items-center gap-3">
              <img 
                src="https://customer-assets.emergentagent.com/job_ai-workshops/artifacts/sp9brvsf_exempler%20logo.webp" 
                alt="Exemplar Global Certified" 
                className="h-8"
              />
              <div className="border-l-2 border-gray-300 pl-3">
                <p className="text-xs text-gray-700 font-semibold">Globally Recognized Certification</p>
              </div>
            </div>
          </div>

          {/* Main Headline - Benefit-Driven */}
          <h1 className="text-4xl md:text-6xl font-black text-center text-gray-900 mb-6 leading-tight">
            Land Your Dream Marketing Job in 6 Months or Get <span className="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-purple-600">100% Money Back</span>
          </h1>

          <p className="text-xl md:text-2xl text-center text-gray-600 mb-8 max-w-4xl mx-auto">
            Master AI-Powered Digital Marketing, Get Certified by Exemplar Global, and Start Your 6-Figure Career with Guaranteed Placement Support
          </p>

          {/* Hero Image */}
          <div className="mb-8 rounded-2xl overflow-hidden shadow-2xl">
            <img 
              src="https://customer-assets.emergentagent.com/job_academy-revamp-2/artifacts/75drn3yc_Untitled%20design%20%284%29.jpg"
              alt="Digital Marketing Success"
              className="w-full h-[400px] md:h-[500px] object-cover"
            />
          </div>

          {/* Course Info Cards */}
          <div className="grid md:grid-cols-3 gap-6 mb-8">
            <div className="bg-gradient-to-br from-blue-50 to-indigo-50 p-6 rounded-xl border border-blue-200">
              <div className="flex items-center gap-3 mb-2">
                <Clock className="w-6 h-6 text-blue-600" />
                <h3 className="font-bold text-lg text-gray-900">6 Months Program</h3>
              </div>
              <p className="text-sm text-gray-600">200+ Hours | Live + Recorded</p>
            </div>

            <div className="bg-gradient-to-br from-green-50 to-emerald-50 p-6 rounded-xl border border-green-200">
              <div className="flex items-center gap-3 mb-2">
                <Calendar className="w-6 h-6 text-green-600" />
                <h3 className="font-bold text-lg text-gray-900">Starts Dec 15, 2025</h3>
              </div>
              <p className="text-sm text-gray-600">Next Cohort | Limited Seats</p>
            </div>

            <div className="bg-gradient-to-br from-purple-50 to-pink-50 p-6 rounded-xl border border-purple-200">
              <div className="flex items-center gap-3 mb-2">
                <Award className="w-6 h-6 text-purple-600" />
                <h3 className="font-bold text-lg text-gray-900">100% Placement</h3>
              </div>
              <p className="text-sm text-gray-600">Job Guarantee | Resume + Interview Prep</p>
            </div>
          </div>

          {/* Countdown Timer */}
          <div className="bg-gradient-to-r from-orange-500 to-red-500 rounded-2xl p-8 mb-8 text-white">
            <p className="text-center text-2xl font-bold mb-6">⏰ 50% OFF ENDS IN:</p>
            <div className="grid grid-cols-4 gap-4 max-w-2xl mx-auto mb-6">
              <div className="text-center">
                <div className="bg-white text-gray-900 rounded-xl p-4 font-black text-4xl">{timeLeft.days}</div>
                <p className="text-sm mt-2">Days</p>
              </div>
              <div className="text-center">
                <div className="bg-white text-gray-900 rounded-xl p-4 font-black text-4xl">{timeLeft.hours}</div>
                <p className="text-sm mt-2">Hours</p>
              </div>
              <div className="text-center">
                <div className="bg-white text-gray-900 rounded-xl p-4 font-black text-4xl">{timeLeft.minutes}</div>
                <p className="text-sm mt-2">Minutes</p>
              </div>
              <div className="text-center">
                <div className="bg-white text-gray-900 rounded-xl p-4 font-black text-4xl">{timeLeft.seconds}</div>
                <p className="text-sm mt-2">Seconds</p>
              </div>
            </div>
            <div className="text-center">
              <p className="text-lg mb-4">Only 30 Seats Left!</p>
              <div className="flex flex-col sm:flex-row gap-4 justify-center">
                <button
                  onClick={() => handleBookingClick('hero_timer')}
                  className="bg-white text-gray-900 px-10 py-4 rounded-full font-black text-xl hover:scale-105 transition-all inline-flex items-center gap-3 shadow-xl"
                >
                  🔥 Book Slot - Just $20
                  <ArrowRight className="w-6 h-6" />
                </button>
                <button
                  onClick={() => handleEnrollClick('hero_timer')}
                  className="bg-transparent border-2 border-white text-white px-10 py-4 rounded-full font-bold text-xl hover:bg-white/20 transition-all inline-flex items-center gap-3"
                >
                  Enroll Full Course
                  <ArrowRight className="w-6 h-6" />
                </button>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Social Proof - Testimonials */}
      <section className="bg-gray-50 py-16 px-6">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-4">
            What Industry Leaders Say
          </h2>
          <p className="text-center text-xl text-gray-600 mb-12">Join thousands who transformed their careers</p>

          <div className="grid md:grid-cols-3 gap-8">
            {testimonials.map((testimonial, index) => (
              <div key={index} className="bg-white rounded-2xl p-8 shadow-lg border border-gray-200">
                <div className="flex gap-1 mb-4">
                  {[...Array(testimonial.rating)].map((_, i) => (
                    <Star key={i} className="w-5 h-5 fill-yellow-400 text-yellow-400" />
                  ))}
                </div>
                <p className="text-gray-700 mb-6 italic text-lg">"{testimonial.quote}"</p>
                <div>
                  <p className="font-bold text-gray-900 text-lg">{testimonial.name}</p>
                  <p className="text-sm text-gray-600">{testimonial.role}</p>
                  <p className="text-xs text-gray-500">{testimonial.company}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Numbers Section */}
      <section className="bg-white py-16 px-6">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-12">
            We'll Let the Numbers Talk
          </h2>

          <div className="grid md:grid-cols-4 gap-8">
            {stats.map((stat, index) => (
              <div key={index} className="text-center">
                <div className="flex justify-center mb-4">{stat.icon}</div>
                <p className="text-5xl font-black text-gray-900 mb-2">{stat.number}</p>
                <p className="text-gray-600 font-semibold">{stat.label}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Company Logos */}
      <section className="bg-gray-50 py-12 px-6">
        <div className="container mx-auto max-w-6xl">
          <p className="text-center text-gray-600 font-semibold mb-8">Learners from Brands Like</p>
          <div className="flex flex-wrap items-center justify-center gap-8">
            {["Google", "Meta", "Amazon", "Microsoft", "Flipkart", "Swiggy", "Zomato", "Myntra"].map((company, i) => (
              <div key={i} className="bg-white px-6 py-3 rounded-lg border border-gray-200 font-bold text-gray-700">
                {company}
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* This Course is For */}
      <section className="bg-white py-16 px-6">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-12">
            This Course is Perfect For Those Who Want To
          </h2>

          <div className="grid md:grid-cols-3 gap-6">
            {forWhom.map((item, index) => (
              <div key={index} className="bg-gradient-to-br from-blue-50 to-purple-50 p-6 rounded-xl border border-blue-200">
                <div className="text-4xl mb-4">{item.icon}</div>
                <h3 className="font-bold text-xl text-gray-900 mb-2">{item.title}</h3>
                <p className="text-gray-600 text-sm">{item.desc}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Curriculum - Day by Day */}
      <section className="bg-gradient-to-br from-blue-50 to-indigo-50 py-16 px-6">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-4">
            What Will You Master in 6 Months?
          </h2>
          <p className="text-center text-xl text-gray-600 mb-12">Complete roadmap to becoming a certified digital marketer</p>

          <div className="space-y-6">
            {curriculum.map((module, index) => (
              <div key={index} className="bg-white rounded-2xl p-8 shadow-lg border border-gray-200">
                <div className="flex items-start gap-4 mb-4">
                  <div className="bg-gradient-to-r from-blue-600 to-purple-600 text-white px-4 py-2 rounded-lg font-black text-sm flex-shrink-0">
                    {module.day}
                  </div>
                  <div className="flex-1">
                    <h3 className="text-2xl font-bold text-gray-900 mb-4">{module.title}</h3>
                    <ul className="space-y-3">
                      {module.topics.map((topic, idx) => (
                        <li key={idx} className="flex items-start gap-3">
                          <CheckCircle2 className="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" />
                          <span className="text-gray-700">{topic}</span>
                        </li>
                      ))}
                    </ul>
                  </div>
                </div>
              </div>
            ))}
          </div>

          <div className="text-center mt-12">
            <button
              onClick={() => handleEnrollClick('curriculum_cta')}
              className="bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white px-10 py-5 rounded-full font-black text-xl shadow-2xl hover:scale-105 transition-all inline-flex items-center gap-3"
            >
              Start Your Journey Today
              <ArrowRight className="w-6 h-6" />
            </button>
          </div>
        </div>
      </section>

      {/* Tools Section */}
      <section className="bg-white py-16 px-6">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-12">
            Master 12+ Industry-Leading Tools
          </h2>

          <div className="flex flex-wrap items-center justify-center gap-6">
            {tools.map((tool, i) => (
              <div key={i} className="bg-gradient-to-br from-gray-50 to-gray-100 px-6 py-4 rounded-xl border border-gray-300 font-bold text-gray-800 text-lg">
                {tool}
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Pricing Section */}
      <section className="bg-gradient-to-br from-yellow-50 to-orange-50 py-16 px-6">
        <div className="container mx-auto max-w-4xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-12">
            Limited Time Pricing
          </h2>

          <div className="bg-white rounded-3xl p-10 shadow-2xl border-4 border-yellow-400 relative">
            {/* Badge */}
            <div className="absolute -top-6 left-1/2 transform -translate-x-1/2">
              <div className="bg-gradient-to-r from-red-500 to-orange-500 text-white px-8 py-3 rounded-full font-black text-lg shadow-xl">
                🔥 50% OFF - ENDS SOON
              </div>
            </div>

            <div className="text-center mt-6">
              <div className="flex items-baseline justify-center gap-4 mb-6">
                <span className="text-7xl font-black text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-purple-600">$299</span>
                <span className="text-4xl text-gray-400 line-through">$599</span>
              </div>

              <p className="text-xl text-gray-600 mb-8">Save $300 Today • Full Course + Certification + Placement</p>

              <ul className="space-y-4 mb-8 text-left max-w-md mx-auto">
                {[
                  "Complete 6-month program access",
                  "Exemplar Global Certification",
                  "Live classes + Recorded sessions",
                  "100% placement assistance",
                  "Hands-on projects & assignments",
                  "Lifetime community access",
                  "Course completion certificate",
                  "Interview preparation & resume building"
                ].map((item, i) => (
                  <li key={i} className="flex items-start gap-3">
                    <CheckCircle2 className="w-6 h-6 text-green-500 flex-shrink-0 mt-0.5" />
                    <span className="text-gray-700 font-medium">{item}</span>
                  </li>
                ))}
              </ul>

              <button
                onClick={() => handleEnrollClick('pricing_cta')}
                className="bg-gradient-to-r from-yellow-400 to-orange-500 hover:from-yellow-500 hover:to-orange-600 text-gray-900 px-12 py-6 rounded-full font-black text-2xl shadow-2xl hover:scale-105 transition-all inline-flex items-center gap-3 w-full justify-center"
              >
                Enroll Now & Save $300
                <ArrowRight className="w-7 h-7" />
              </button>

              <p className="text-sm text-gray-600 mt-6">
                💳 Secure Payment • 🔒 7-Day Money-Back Guarantee • 📞 24/7 Support
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Bonuses Section */}
      <section className="bg-white py-16 px-6">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-12">
            Free Bonuses Worth $5,000
          </h2>

          <div className="grid md:grid-cols-3 gap-8">
            {[
              { title: "AI Marketing Templates", value: "$1,500", desc: "50+ ChatGPT prompts and automation workflows" },
              { title: "Exclusive Masterclasses", value: "$2,000", desc: "Guest sessions from industry experts" },
              { title: "Lifetime Job Support", value: "$1,500", desc: "Resume reviews, mock interviews, job referrals" }
            ].map((bonus, i) => (
              <div key={i} className="bg-gradient-to-br from-purple-50 to-pink-50 p-8 rounded-2xl border border-purple-200">
                <p className="text-3xl font-black text-purple-600 mb-2">{bonus.value}</p>
                <h3 className="text-xl font-bold text-gray-900 mb-3">{bonus.title}</h3>
                <p className="text-gray-600">{bonus.desc}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* FAQ Section */}
      <section className="bg-gray-50 py-16 px-6">
        <div className="container mx-auto max-w-4xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-12">
            Frequently Asked Questions
          </h2>

          <div className="space-y-4">
            {[
              { q: "Is this course suitable for beginners?", a: "Absolutely! The course starts with fundamentals and progressively moves to advanced topics. No prior experience required." },
              { q: "What is the placement guarantee?", a: "We provide 100% placement assistance including resume building, interview preparation, and direct connections to 500+ hiring partners until you get placed." },
              { q: "Can I access the course while working full-time?", a: "Yes! The course is designed for working professionals with flexible timings and recorded sessions available 24/7." },
              { q: "Is the certification globally recognized?", a: "Yes, you'll receive Exemplar Global certification which is recognized by employers in 100+ countries worldwide." },
              { q: "What if I'm not satisfied with the course?", a: "We offer a 7-day money-back guarantee. If you're not satisfied, we'll refund your full payment, no questions asked." }
            ].map((faq, i) => (
              <div key={i} className="bg-white rounded-xl p-6 border border-gray-200">
                <h3 className="text-lg font-bold text-gray-900 mb-2">{faq.q}</h3>
                <p className="text-gray-600">{faq.a}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Final CTA */}
      <section className="bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 py-20 px-6 text-white">
        <div className="container mx-auto max-w-4xl text-center">
          <h2 className="text-4xl md:text-6xl font-black mb-6">
            Don't Miss Out on This Limited-Time Offer
          </h2>
          <p className="text-xl md:text-2xl mb-8">
            Join 30,000+ successful students who transformed their careers
          </p>

          <div className="bg-white/10 backdrop-blur-md rounded-2xl p-8 mb-8 border border-white/20">
            <p className="text-2xl font-bold mb-4">⏰ Only 30 Seats Left!</p>
            <p className="text-lg mb-6">50% Discount Ends in {timeLeft.days}d {timeLeft.hours}h {timeLeft.minutes}m</p>
          </div>

          <button
            onClick={() => handleEnrollClick('final_cta')}
            className="bg-white text-gray-900 px-12 py-6 rounded-full font-black text-2xl shadow-2xl hover:scale-105 transition-all inline-flex items-center gap-3"
          >
            Reserve Your Seat Now
            <ArrowRight className="w-7 h-7" />
          </button>

          <p className="text-sm mt-8 opacity-90">
            🔒 Secure Payment • 💯 Money-back Guarantee • 📞 Instant Support
          </p>
        </div>
      </section>

      {/* Footer */}
      <footer className="py-8 px-6 bg-gray-900 text-white text-center">
        <p className="mb-2">© 2025 AI School for All. All rights reserved.</p>
        <p className="text-sm text-gray-400">Powered by Workshop Library | Exemplar Global Certified</p>
      </footer>

      {/* Booking Modal */}
      {showBookingModal && (
        <div className="fixed inset-0 bg-black/60 backdrop-blur-sm z-50 flex items-center justify-center p-4">
          <div className="relative max-w-2xl w-full max-h-[90vh] overflow-y-auto">
            <button
              onClick={() => setShowBookingModal(false)}
              className="absolute -top-4 -right-4 bg-white rounded-full p-2 shadow-xl hover:scale-110 transition-all z-10"
            >
              <X className="w-6 h-6 text-gray-900" />
            </button>
            <BookingForm onClose={() => setShowBookingModal(false)} />
          </div>
        </div>
      )}
    </div>
  );
};

export default CSDGPMLandingPageNew;
