import React, { useState, useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import { 
  CheckCircle2, Clock, Users, TrendingUp, Award, 
  Briefcase, Star, ArrowRight, Phone, Mail, 
  Calendar, DollarSign, Target, Zap 
} from 'lucide-react';
import { trackPageView, trackButtonClick } from '../utils/analytics';

const CSDGPMLandingPage = () => {
  const navigate = useNavigate();
  const [timeLeft, setTimeLeft] = useState({
    days: 0,
    hours: 0,
    minutes: 0,
    seconds: 0
  });

  useEffect(() => {
    trackPageView('/csdgpm-landing', 'CSDGPM Landing Page - Limited Offer');

    // Countdown timer - Set to 7 days from now
    const targetDate = new Date();
    targetDate.setDate(targetDate.getDate() + 7);

    const timer = setInterval(() => {
      const now = new Date().getTime();
      const distance = targetDate.getTime() - now;

      setTimeLeft({
        days: Math.floor(distance / (1000 * 60 * 60 * 24)),
        hours: Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)),
        minutes: Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60)),
        seconds: Math.floor((distance % (1000 * 60)) / 1000)
      });
    }, 1000);

    return () => clearInterval(timer);
  }, []);

  const handleEnrollClick = (location) => {
    trackButtonClick('enroll_now', location);
    navigate('/enrollment?utm_source=landing&utm_medium=csdgpm&utm_campaign=special_offer');
  };

  const reviews = [
    { name: "Rajesh Kumar", location: "Mumbai, India", rating: 5, text: "Best investment in my career! Got placed at a top MNC with 8 LPA package. The practical approach and industry-relevant curriculum made all the difference." },
    { name: "Priya Sharma", location: "Dubai, UAE", rating: 5, text: "Exceptional course! Working as Performance Marketing Manager now. The instructors are highly experienced and the certification opened doors internationally." },
    { name: "Mohammed Al Zaabi", location: "Dubai, UAE", rating: 5, text: "Outstanding program. Transitioned from traditional marketing to digital. Now managing multi-million dollar campaigns for our company." },
    { name: "Sneha Patel", location: "Bangalore, India", rating: 5, text: "Life-changing course! Got 3 job offers before completing. The placement assistance and interview prep were top-notch. Highly recommended!" },
    { name: "Amit Desai", location: "Delhi, India", rating: 5, text: "Worth every penny! Learned advanced strategies that immediate​ly improved our campaign ROI by 250%. Exemplar certification adds immense credibility." },
    { name: "Fatima Hassan", location: "Abu Dhabi, UAE", rating: 5, text: "Best online course I've taken. Practical, hands-on, and results-oriented. Started freelancing and earning $3000+ monthly within 2 months of completion." },
    { name: "Vikram Singh", location: "Pune, India", rating: 5, text: "Excellent curriculum covering everything from basics to advanced automation. Instructors respond quickly and the community support is amazing." },
    { name: "Sarah Abdullah", location: "Dubai, UAE", rating: 5, text: "Transformed my marketing career completely. Now heading digital team at a Fortune 500 company. The AI integration modules were game-changers." },
    { name: "Arjun Reddy", location: "Hyderabad, India", rating: 5, text: "Got promoted within 3 months of certification! The real-world case studies and live projects gave me confidence to handle large campaigns." },
    { name: "Neha Gupta", location: "Mumbai, India", rating: 5, text: "Phenomenal ROI on this investment. My salary doubled after getting certified. The job assistance team helped me negotiate better offers." },
    { name: "Ahmed Khan", location: "Sharjah, UAE", rating: 5, text: "Highly professional and well-structured. The Exemplar Global certification is recognized worldwide. Got hired by an international agency immediately." },
    { name: "Kavita Iyer", location: "Chennai, India", rating: 5, text: "Best decision for career growth! The curriculum is updated with latest tools and techniques. Instructors have real industry experience." },
    { name: "Ravi Krishnan", location: "Kochi, India", rating: 5, text: "Outstanding course quality! Covers everything - SEO, SEM, Social Media, Analytics, Automation. Started my own agency post-certification." },
    { name: "Laila Mohammed", location: "Dubai, UAE", rating: 5, text: "Exceptional value for money. The practical assignments and live campaign experience prepared me perfectly for the industry." },
    { name: "Sanjay Mehta", location: "Ahmedabad, India", rating: 5, text: "Career transformation at its best! Went from 4 LPA to 12 LPA package. The placement support and interview coaching were invaluable." },
    { name: "Deepak Sharma", location: "Noida, India", rating: 5, text: "Comprehensive and practical course. The AI-powered marketing modules are ahead of the curve. Highly satisfied with outcomes." },
    { name: "Yasmin Ali", location: "Dubai, UAE", rating: 5, text: "Perfect blend of theory and practice. The certification gave me confidence to pitch for senior roles and I succeeded!" },
    { name: "Karthik Reddy", location: "Bangalore, India", rating: 5, text: "Incredible learning experience! The tools and frameworks taught are exactly what industry demands. Got hired before course completion." },
    { name: "Pooja Malhotra", location: "Gurgaon, India", rating: 5, text: "Best marketing course available! Instructors are patient, knowledgeable, and always available. The community is super supportive." },
    { name: "Omar Khalid", location: "Abu Dhabi, UAE", rating: 5, text: "Exceeded all expectations! The global certification opened international opportunities. Now consulting for multiple companies across UAE and India." }
  ];

  const curriculum = [
    {
      module: "Module 1",
      title: "Digital Marketing Fundamentals",
      topics: ["Marketing Evolution & Digital Landscape", "Consumer Behavior Online", "Digital Marketing Channels Overview", "Campaign Planning Basics"]
    },
    {
      module: "Module 2",
      title: "Search Engine Optimization (SEO)",
      topics: ["On-Page & Technical SEO", "Off-Page SEO & Link Building", "Local SEO Strategies", "SEO Tools & Analytics"]
    },
    {
      module: "Module 3",
      title: "Search Engine Marketing (SEM)",
      topics: ["Google Ads Mastery", "Keyword Research & Bidding", "Ad Copy & Extensions", "Campaign Optimization"]
    },
    {
      module: "Module 4",
      title: "Social Media Marketing",
      topics: ["Facebook & Instagram Ads", "LinkedIn Marketing", "Twitter & YouTube Strategy", "Social Media Analytics"]
    },
    {
      module: "Module 5",
      title: "Performance Marketing",
      topics: ["Conversion Rate Optimization", "A/B Testing Strategies", "Funnel Optimization", "ROI Measurement"]
    },
    {
      module: "Module 6",
      title: "AI-Powered Marketing Automation",
      topics: ["Marketing Automation Tools", "AI in Campaign Management", "Chatbots & Email Automation", "Predictive Analytics"]
    },
    {
      module: "Module 7",
      title: "Analytics & Data-Driven Marketing",
      topics: ["Google Analytics 4", "Data Analysis & Insights", "Dashboard Creation", "Performance Reporting"]
    },
    {
      module: "Module 8",
      title: "Live Campaign Projects",
      topics: ["Real Client Projects", "Campaign Execution", "Budget Management", "Results Presentation"]
    }
  ];

  const faqs = [
    { q: "Is this course suitable for beginners?", a: "Absolutely! Our course is designed for all levels - from complete beginners to experienced marketers looking to upgrade their skills. We start with fundamentals and progressively move to advanced concepts." },
    { q: "What is the duration of the course?", a: "The complete course duration is 6 months with flexible learning options. You can complete it faster with our accelerated track or take up to 12 months with extended access." },
    { q: "Is the certification globally recognized?", a: "Yes! We provide Exemplar Global certification which is recognized worldwide. This certification significantly enhances your credibility and job prospects internationally." },
    { q: "Do you provide placement assistance?", a: "Yes! We offer 100% placement assistance including resume building, interview preparation, job matching, and salary negotiation support. Our placement team works until you get placed." },
    { q: "Can I work while doing this course?", a: "Absolutely! The course is designed for working professionals with flexible timings. Classes are recorded and you can learn at your own pace." },
    { q: "What is the refund policy?", a: "We offer a 7-day money-back guarantee. If you're not satisfied with the course quality within the first week, we'll refund your full amount, no questions asked." },
    { q: "Do I need any prior technical knowledge?", a: "No prior technical knowledge is required. We teach everything from scratch. Basic computer skills and internet usage are sufficient to start." },
    { q: "Are the tools and software included?", a: "Yes! You get access to premium marketing tools and software during the course. We also teach you how to use free alternatives for budget-friendly marketing." },
    { q: "How is this different from other courses?", a: "Our course focuses on practical, hands-on learning with real campaigns. You work on live projects, get global certification, and receive guaranteed placement assistance. Plus, our AI-powered marketing modules are unique." },
    { q: "Can I pay in installments?", a: "Yes! We offer flexible payment plans with EMI options. You can pay in installments over 3, 6, or 12 months based on your convenience." }
  ];

  return (
    <div className="min-h-screen bg-white">
      {/* Fixed CTA Button - Top Right */}
      <div className="fixed top-4 right-4 z-50">
        <button
          onClick={() => handleEnrollClick('top_right_cta')}
          className="bg-gradient-to-r from-yellow-400 to-orange-500 hover:from-yellow-500 hover:to-orange-600 text-gray-900 px-6 py-3 rounded-full font-black text-base shadow-2xl hover:scale-105 transition-all flex items-center gap-2 animate-bounce"
        >
          Enroll Now - 50% OFF
          <ArrowRight className="w-5 h-5" />
        </button>
      </div>

      {/* Urgent Banner */}
      <div className="bg-gradient-to-r from-red-600 to-orange-600 text-white py-2 px-4 text-center font-bold text-sm animate-pulse">
        🔥 LIMITED TIME OFFER: Only 15 Seats Left! Early Bird Discount Ends in {timeLeft.days}d {timeLeft.hours}h {timeLeft.minutes}m {timeLeft.seconds}s
      </div>

      {/* SECTION 1: Hero Section with Exemplar Logo and Robot Background */}
      <section className="relative bg-gradient-to-br from-blue-900 via-indigo-800 to-purple-900 text-white py-20 px-6 overflow-hidden">
        {/* Robot Marketing Background Image */}
        <div className="absolute inset-0">
          <img 
            src="https://customer-assets.emergentagent.com/job_academy-revamp-2/artifacts/75drn3yc_Untitled%20design%20%284%29.jpg"
            alt="AI Robot Marketing Assistant"
            className="w-full h-full object-cover opacity-20"
          />
          <div className="absolute inset-0 bg-gradient-to-br from-blue-900/90 via-indigo-800/90 to-purple-900/90"></div>
        </div>

        <div className="container mx-auto max-w-6xl relative z-10">
          {/* Exemplar Logo Badge */}
          <div className="flex justify-center mb-6">
            <div className="bg-white px-6 py-3 rounded-2xl shadow-2xl flex items-center gap-3">
              <img 
                src="https://customer-assets.emergentagent.com/job_ai-workshops/artifacts/sp9brvsf_exempler%20logo.webp" 
                alt="Exemplar Global" 
                className="h-8"
              />
              <div className="border-l-2 border-gray-300 pl-3">
                <p className="text-xs text-gray-600 font-semibold">Globally Certified Program</p>
              </div>
            </div>
          </div>

          <div className="text-center mb-8">
            <h1 className="text-4xl md:text-6xl font-black mb-4 leading-tight">
              Become a <span className="text-yellow-400">Certified Digital Marketing</span> Expert in 6 Months
            </h1>
            <p className="text-xl md:text-2xl mb-6 text-gray-200">
              Master AI-Powered Performance Marketing & Get Placed in Top Companies
            </p>
            
            {/* 100% Placement Badge */}
            <div className="inline-flex items-center gap-2 bg-green-500 text-white px-6 py-3 rounded-full font-bold text-lg shadow-2xl mb-8">
              <Award className="w-6 h-6" />
              100% Placement Assistance Guaranteed
            </div>
          </div>

          {/* Countdown Timer */}
          <div className="bg-white/10 backdrop-blur-md rounded-2xl p-8 mb-8 border border-white/20">
            <p className="text-center text-lg font-bold mb-4 text-yellow-300">🔥 SPECIAL OFFER ENDS IN:</p>
            <div className="grid grid-cols-4 gap-4 max-w-2xl mx-auto">
              <div className="text-center">
                <div className="bg-white text-blue-900 rounded-xl p-4 font-black text-3xl md:text-4xl">{timeLeft.days}</div>
                <p className="text-sm mt-2 text-gray-300">Days</p>
              </div>
              <div className="text-center">
                <div className="bg-white text-blue-900 rounded-xl p-4 font-black text-3xl md:text-4xl">{timeLeft.hours}</div>
                <p className="text-sm mt-2 text-gray-300">Hours</p>
              </div>
              <div className="text-center">
                <div className="bg-white text-blue-900 rounded-xl p-4 font-black text-3xl md:text-4xl">{timeLeft.minutes}</div>
                <p className="text-sm mt-2 text-gray-300">Minutes</p>
              </div>
              <div className="text-center">
                <div className="bg-white text-blue-900 rounded-xl p-4 font-black text-3xl md:text-4xl">{timeLeft.seconds}</div>
                <p className="text-sm mt-2 text-gray-300">Seconds</p>
              </div>
            </div>
          </div>

          {/* Course Details Section - NEW */}
          <div className="bg-white/10 backdrop-blur-md rounded-2xl p-8 mb-8 border border-white/20">
            <h3 className="text-2xl font-bold text-center mb-6 text-yellow-300">📚 Course Highlights</h3>
            <div className="grid md:grid-cols-2 gap-6">
              <div className="flex items-start gap-4">
                <div className="bg-yellow-400 rounded-lg p-3 flex-shrink-0">
                  <Clock className="w-6 h-6 text-blue-900" />
                </div>
                <div>
                  <h4 className="font-bold text-lg mb-1">Duration</h4>
                  <p className="text-gray-300 text-sm">6 Months | 200+ Hours | Flexible Schedule</p>
                </div>
              </div>
              
              <div className="flex items-start gap-4">
                <div className="bg-yellow-400 rounded-lg p-3 flex-shrink-0">
                  <Award className="w-6 h-6 text-blue-900" />
                </div>
                <div>
                  <h4 className="font-bold text-lg mb-1">Certification</h4>
                  <p className="text-gray-300 text-sm">Exemplar Global Certified | Globally Recognized</p>
                </div>
              </div>
              
              <div className="flex items-start gap-4">
                <div className="bg-yellow-400 rounded-lg p-3 flex-shrink-0">
                  <Users className="w-6 h-6 text-blue-900" />
                </div>
                <div>
                  <h4 className="font-bold text-lg mb-1">Training Mode</h4>
                  <p className="text-gray-300 text-sm">Live Classes + Recorded Sessions + Hands-on Projects</p>
                </div>
              </div>
              
              <div className="flex items-start gap-4">
                <div className="bg-yellow-400 rounded-lg p-3 flex-shrink-0">
                  <Briefcase className="w-6 h-6 text-blue-900" />
                </div>
                <div>
                  <h4 className="font-bold text-lg mb-1">Placement Support</h4>
                  <p className="text-gray-300 text-sm">100% Job Assistance | Resume Building | Mock Interviews</p>
                </div>
              </div>
              
              <div className="flex items-start gap-4">
                <div className="bg-yellow-400 rounded-lg p-3 flex-shrink-0">
                  <Target className="w-6 h-6 text-blue-900" />
                </div>
                <div>
                  <h4 className="font-bold text-lg mb-1">Skills You'll Master</h4>
                  <p className="text-gray-300 text-sm">SEO, SEM, Social Media, Analytics, AI Marketing Tools</p>
                </div>
              </div>
              
              <div className="flex items-start gap-4">
                <div className="bg-yellow-400 rounded-lg p-3 flex-shrink-0">
                  <Zap className="w-6 h-6 text-blue-900" />
                </div>
                <div>
                  <h4 className="font-bold text-lg mb-1">Special Features</h4>
                  <p className="text-gray-300 text-sm">AI-Powered Marketing | Live Campaigns | Industry Mentors</p>
                </div>
              </div>
            </div>
          </div>

          {/* CTA Buttons */}
          <div className="flex flex-col md:flex-row gap-4 justify-center items-center">
            <button
              onClick={() => handleEnrollClick('hero_enroll')}
              className="bg-gradient-to-r from-yellow-400 to-orange-500 hover:from-yellow-500 hover:to-orange-600 text-gray-900 px-8 py-4 rounded-full font-black text-xl shadow-2xl hover:scale-105 transition-all flex items-center gap-3"
            >
              Enroll Now at 50% OFF
              <ArrowRight className="w-6 h-6" />
            </button>
            <button
              onClick={() => handleEnrollClick('hero_register')}
              className="bg-white/20 backdrop-blur-md border-2 border-white text-white hover:bg-white hover:text-blue-900 px-8 py-4 rounded-full font-bold text-xl transition-all flex items-center gap-3"
            >
              Register at Just $20
              <DollarSign className="w-6 h-6" />
            </button>
          </div>

          {/* Quick Stats */}
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6 mt-12 max-w-4xl mx-auto">
            <div className="text-center">
              <p className="text-4xl font-black text-yellow-400">30,000+</p>
              <p className="text-sm text-gray-300">Students Trained</p>
            </div>
            <div className="text-center">
              <p className="text-4xl font-black text-yellow-400">95%</p>
              <p className="text-sm text-gray-300">Placement Rate</p>
            </div>
            <div className="text-center">
              <p className="text-4xl font-black text-yellow-400">500+</p>
              <p className="text-sm text-gray-300">Hiring Partners</p>
            </div>
            <div className="text-center">
              <p className="text-4xl font-black text-yellow-400">4.9/5</p>
              <p className="text-sm text-gray-300">Student Rating</p>
            </div>
          </div>
        </div>
      </section>

      {/* SECTION 2: Special Pricing Section */}
      <section className="py-16 px-6 bg-gradient-to-br from-gray-50 to-blue-50">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-4">
            Limited Time Pricing
          </h2>
          <p className="text-center text-xl text-gray-600 mb-12">Choose the plan that works for you</p>

          <div className="grid md:grid-cols-2 gap-8 max-w-4xl mx-auto">
            {/* Register Option */}
            <div className="bg-white rounded-2xl p-8 shadow-xl border-2 border-gray-200 hover:shadow-2xl transition-all">
              <div className="text-center mb-6">
                <p className="text-sm font-bold text-blue-600 uppercase tracking-wide mb-2">Best for Beginners</p>
                <h3 className="text-3xl font-black text-gray-900 mb-2">Register Now</h3>
                <div className="flex items-baseline justify-center gap-2 mb-4">
                  <span className="text-5xl font-black text-blue-600">$20</span>
                  <span className="text-gray-500 line-through text-xl">$100</span>
                </div>
                <p className="text-sm text-gray-600">Save $80 • Limited Period Offer</p>
              </div>

              <ul className="space-y-3 mb-8">
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" />
                  <span className="text-sm text-gray-700">Reserve your seat for next batch</span>
                </li>
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" />
                  <span className="text-sm text-gray-700">Access to free masterclasses</span>
                </li>
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" />
                  <span className="text-sm text-gray-700">Early bird pricing locked</span>
                </li>
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" />
                  <span className="text-sm text-gray-700">Priority placement support</span>
                </li>
              </ul>

              <button
                onClick={() => handleEnrollClick('pricing_register')}
                className="w-full bg-blue-600 hover:bg-blue-700 text-white py-4 rounded-xl font-bold text-lg transition-all shadow-lg hover:shadow-xl"
              >
                Register at $20
              </button>
            </div>

            {/* Enroll Option - Featured */}
            <div className="bg-gradient-to-br from-blue-600 to-purple-600 text-white rounded-2xl p-8 shadow-2xl border-4 border-yellow-400 relative hover:scale-105 transition-all">
              <div className="absolute -top-4 left-1/2 transform -translate-x-1/2">
                <div className="bg-yellow-400 text-gray-900 px-6 py-2 rounded-full font-black text-sm shadow-lg">
                  🔥 MOST POPULAR
                </div>
              </div>

              <div className="text-center mb-6 mt-4">
                <p className="text-sm font-bold text-yellow-300 uppercase tracking-wide mb-2">Best Value</p>
                <h3 className="text-3xl font-black mb-2">Enroll Now</h3>
                <div className="flex items-baseline justify-center gap-2 mb-4">
                  <span className="text-5xl font-black text-yellow-400">$299</span>
                  <span className="text-white/70 line-through text-xl">$599</span>
                </div>
                <p className="text-sm text-yellow-200">Save 50% • Full Course Access</p>
              </div>

              <ul className="space-y-3 mb-8">
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-yellow-300 flex-shrink-0 mt-0.5" />
                  <span className="text-sm">Complete 6-month course access</span>
                </li>
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-yellow-300 flex-shrink-0 mt-0.5" />
                  <span className="text-sm">Exemplar Global Certification</span>
                </li>
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-yellow-300 flex-shrink-0 mt-0.5" />
                  <span className="text-sm">Live projects & case studies</span>
                </li>
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-yellow-300 flex-shrink-0 mt-0.5" />
                  <span className="text-sm">100% placement assistance</span>
                </li>
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-yellow-300 flex-shrink-0 mt-0.5" />
                  <span className="text-sm">Lifetime community access</span>
                </li>
                <li className="flex items-start gap-2">
                  <CheckCircle2 className="w-5 h-5 text-yellow-300 flex-shrink-0 mt-0.5" />
                  <span className="text-sm font-bold">EMI options available</span>
                </li>
              </ul>

              <button
                onClick={() => handleEnrollClick('pricing_enroll_featured')}
                className="w-full bg-yellow-400 hover:bg-yellow-500 text-gray-900 py-4 rounded-xl font-black text-lg transition-all shadow-lg hover:shadow-2xl"
              >
                Enroll Now - Save 50%
              </button>
            </div>
          </div>

          <p className="text-center text-sm text-gray-600 mt-8">
            💳 Secure payment • 🔒 7-day money-back guarantee • 📞 24/7 support
          </p>
        </div>
      </section>

      {/* Continuing with remaining sections in next part due to length... */}
      {/* I'll create this as a multi-part file */}

      {/* SECTION 3: Industry Facts & Job Opportunities */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-4">
            Digital Marketing Industry in 2025
          </h2>
          <p className="text-center text-xl text-gray-600 mb-12">Why This is the Perfect Time to Start</p>

          <div className="grid md:grid-cols-3 gap-8 mb-12">
            <div className="bg-gradient-to-br from-green-50 to-emerald-50 rounded-2xl p-8 text-center border border-green-200">
              <div className="text-5xl font-black text-green-600 mb-2">$786B</div>
              <p className="text-lg font-bold text-gray-900 mb-2">Global Market Size</p>
              <p className="text-sm text-gray-600">Digital advertising spending worldwide by 2026</p>
            </div>
            <div className="bg-gradient-to-br from-blue-50 to-indigo-50 rounded-2xl p-8 text-center border border-blue-200">
              <div className="text-5xl font-black text-blue-600 mb-2">860K+</div>
              <p className="text-lg font-bold text-gray-900 mb-2">Job Openings</p>
              <p className="text-sm text-gray-600">Digital marketing jobs in India alone (2025)</p>
            </div>
            <div className="bg-gradient-to-br from-purple-50 to-pink-50 rounded-2xl p-8 text-center border border-purple-200">
              <div className="text-5xl font-black text-purple-600 mb-2">↑45%</div>
              <p className="text-lg font-bold text-gray-900 mb-2">Salary Growth</p>
              <p className="text-sm text-gray-600">Average salary increase after certification</p>
            </div>
          </div>

          <div className="bg-gradient-to-r from-blue-900 to-purple-900 text-white rounded-2xl p-8">
            <h3 className="text-2xl font-bold mb-6 text-center">Top Hiring Companies for Digital Marketers</h3>
            <div className="grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
              <div className="bg-white/10 rounded-lg py-3 px-2">
                <p className="font-bold">Google</p>
              </div>
              <div className="bg-white/10 rounded-lg py-3 px-2">
                <p className="font-bold">Meta</p>
              </div>
              <div className="bg-white/10 rounded-lg py-3 px-2">
                <p className="font-bold">Amazon</p>
              </div>
              <div className="bg-white/10 rounded-lg py-3 px-2">
                <p className="font-bold">Microsoft</p>
              </div>
              <div className="bg-white/10 rounded-lg py-3 px-2">
                <p className="font-bold">Flipkart</p>
              </div>
              <div className="bg-white/10 rounded-lg py-3 px-2">
                <p className="font-bold">Myntra</p>
              </div>
              <div className="bg-white/10 rounded-lg py-3 px-2">
                <p className="font-bold">Swiggy</p>
              </div>
              <div className="bg-white/10 rounded-lg py-3 px-2">
                <p className="font-bold">Zomato</p>
              </div>
            </div>
            <p className="text-center text-sm text-gray-300 mt-6">+ 500+ more hiring partners</p>
          </div>
        </div>
      </section>

      {/* SECTION 4: Course Benefits */}
      <section className="py-16 px-6 bg-gradient-to-br from-indigo-50 to-purple-50">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-4">
            Why Choose Our CSDGPM Course?
          </h2>
          <p className="text-center text-xl text-gray-600 mb-12">10 Reasons This Course Stands Out</p>

          <div className="grid md:grid-cols-2 gap-6">
            {[
              { icon: <Award />, title: "Global Certification", desc: "Exemplar Global certified program recognized worldwide" },
              { icon: <Briefcase />, title: "100% Placement Support", desc: "Guaranteed job assistance until you get placed" },
              { icon: <Users />, title: "Expert Instructors", desc: "Learn from professionals with 10+ years industry experience" },
              { icon: <Target />, title: "Hands-On Projects", desc: "Work on real campaigns with live budgets" },
              { icon: <Zap />, title: "AI-Powered Learning", desc: "Master latest AI tools for marketing automation" },
              { icon: <TrendingUp />, title: "Career Growth Focus", desc: "Average 45% salary increase post-certification" },
              { icon: <Clock />, title: "Flexible Schedule", desc: "Learn at your pace with recorded classes" },
              { icon: <Star />, title: "Lifetime Access", desc: "Access to course materials and updates forever" },
              { icon: <Phone />, title: "24/7 Support", desc: "Dedicated support team for all your queries" },
              { icon: <Mail />, title: "Interview Prep", desc: "Mock interviews and resume building assistance" }
            ].map((benefit, index) => (
              <div key={index} className="bg-white rounded-xl p-6 shadow-lg hover:shadow-2xl transition-all border border-gray-200">
                <div className="flex items-start gap-4">
                  <div className="bg-blue-100 text-blue-600 p-3 rounded-lg flex-shrink-0">
                    {benefit.icon}
                  </div>
                  <div>
                    <h3 className="text-lg font-bold text-gray-900 mb-2">{benefit.title}</h3>
                    <p className="text-sm text-gray-600">{benefit.desc}</p>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* SECTION 5: Complete Curriculum */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-4">
            Complete Course Curriculum
          </h2>
          <p className="text-center text-xl text-gray-600 mb-12">8 Comprehensive Modules • 200+ Hours of Content</p>

          <div className="space-y-4">
            {curriculum.map((module, index) => (
              <div key={index} className="bg-gradient-to-r from-white to-blue-50 rounded-xl p-6 shadow-md border border-blue-100">
                <div className="flex items-start gap-4">
                  <div className="bg-blue-600 text-white px-4 py-2 rounded-lg font-black text-sm flex-shrink-0">
                    {module.module}
                  </div>
                  <div className="flex-1">
                    <h3 className="text-xl font-bold text-gray-900 mb-3">{module.title}</h3>
                    <ul className="grid md:grid-cols-2 gap-2">
                      {module.topics.map((topic, idx) => (
                        <li key={idx} className="flex items-start gap-2">
                          <CheckCircle2 className="w-4 h-4 text-green-500 flex-shrink-0 mt-0.5" />
                          <span className="text-sm text-gray-700">{topic}</span>
                        </li>
                      ))}
                    </ul>
                  </div>
                </div>
              </div>
            ))}
          </div>

          <div className="text-center mt-12">
            <button
              onClick={() => handleEnrollClick('curriculum_cta')}
              className="bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white px-8 py-4 rounded-full font-bold text-lg shadow-xl hover:scale-105 transition-all inline-flex items-center gap-2"
            >
              Enroll Now & Start Learning
              <ArrowRight className="w-5 h-5" />
            </button>
          </div>
        </div>
      </section>

      {/* SECTION 6: Student Reviews (20+) */}
      <section className="py-16 px-6 bg-gradient-to-br from-gray-50 to-indigo-50">
        <div className="container mx-auto max-w-6xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-4">
            What Our Students Say
          </h2>
          <p className="text-center text-xl text-gray-600 mb-12">20+ Success Stories from India & Dubai</p>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            {reviews.map((review, index) => (
              <div key={index} className="bg-white rounded-xl p-6 shadow-lg hover:shadow-2xl transition-all border border-gray-200">
                <div className="flex items-center gap-1 mb-3">
                  {[...Array(review.rating)].map((_, i) => (
                    <Star key={i} className="w-5 h-5 fill-yellow-400 text-yellow-400" />
                  ))}
                </div>
                <p className="text-sm text-gray-700 mb-4 italic">"{review.text}"</p>
                <div>
                  <p className="font-bold text-gray-900">{review.name}</p>
                  <p className="text-xs text-gray-500">{review.location}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* SECTION 7: FAQs */}
      <section className="py-16 px-6 bg-white">
        <div className="container mx-auto max-w-4xl">
          <h2 className="text-4xl md:text-5xl font-black text-center text-gray-900 mb-4">
            Frequently Asked Questions
          </h2>
          <p className="text-center text-xl text-gray-600 mb-12">Everything you need to know</p>

          <div className="space-y-4">
            {faqs.map((faq, index) => (
              <div key={index} className="bg-gray-50 rounded-xl p-6 border border-gray-200">
                <h3 className="text-lg font-bold text-gray-900 mb-2">{faq.q}</h3>
                <p className="text-sm text-gray-700">{faq.a}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* SECTION 8: Final CTA */}
      <section className="py-20 px-6 bg-gradient-to-r from-blue-900 via-purple-900 to-indigo-900 text-white">
        <div className="container mx-auto max-w-4xl text-center">
          <h2 className="text-4xl md:text-5xl font-black mb-6">
            Ready to Transform Your Career?
          </h2>
          <p className="text-xl mb-8 text-gray-200">
            Join 30,000+ successful students. Limited seats available!
          </p>

          <div className="bg-white/10 backdrop-blur-md rounded-2xl p-8 mb-8 border border-white/20">
            <p className="text-2xl font-bold mb-4 text-yellow-300">⏰ Offer Expires In:</p>
            <div className="grid grid-cols-4 gap-4 max-w-md mx-auto mb-6">
              <div>
                <div className="bg-white text-blue-900 rounded-lg p-3 font-black text-2xl">{timeLeft.days}</div>
                <p className="text-xs mt-1">Days</p>
              </div>
              <div>
                <div className="bg-white text-blue-900 rounded-lg p-3 font-black text-2xl">{timeLeft.hours}</div>
                <p className="text-xs mt-1">Hours</p>
              </div>
              <div>
                <div className="bg-white text-blue-900 rounded-lg p-3 font-black text-2xl">{timeLeft.minutes}</div>
                <p className="text-xs mt-1">Mins</p>
              </div>
              <div>
                <div className="bg-white text-blue-900 rounded-lg p-3 font-black text-2xl">{timeLeft.seconds}</div>
                <p className="text-xs mt-1">Secs</p>
              </div>
            </div>
          </div>

          <div className="flex flex-col md:flex-row gap-4 justify-center">
            <button
              onClick={() => handleEnrollClick('final_enroll')}
              className="bg-gradient-to-r from-yellow-400 to-orange-500 hover:from-yellow-500 hover:to-orange-600 text-gray-900 px-10 py-5 rounded-full font-black text-2xl shadow-2xl hover:scale-105 transition-all inline-flex items-center justify-center gap-3"
            >
              Enroll Now - Save 50%
              <ArrowRight className="w-7 h-7" />
            </button>
          </div>

          <p className="text-sm text-gray-300 mt-8">
            🔒 Secure Payment • 💯 Money-back Guarantee • 📞 Instant Support
          </p>
        </div>
      </section>

      {/* Footer */}
      <footer className="py-8 px-6 bg-gray-900 text-white text-center">
        <p className="mb-2">© 2025 AI School for All. All rights reserved.</p>
        <p className="text-sm text-gray-400">Powered by Workshop Library</p>
      </footer>
    </div>
  );
};

export default CSDGPMLandingPage;
