import "./App.css";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import LandingPage from "./pages/LandingPage";
import EnrollmentPage from "./pages/EnrollmentPage";
import CSDGPMLandingPage from "./pages/CSDGPMLandingPage";
import CSDGPMLandingPageNew from "./pages/CSDGPMLandingPageNew";
import CourseCSDGPM from "./pages/CourseCSDGPM";
import WorkshopPhotoEditing from "./pages/WorkshopPhotoEditing";
import WorkshopVideoEditing from "./pages/WorkshopVideoEditing";
import WorkshopSocialMedia from "./pages/WorkshopSocialMedia";
import WorkshopLinkedIn from "./pages/WorkshopLinkedIn";
import WorkshopPromptEngineering from "./pages/WorkshopPromptEngineering";
import WorkshopCanvaDesign from "./pages/WorkshopCanvaDesign";
import WorkshopFreelancing from "./pages/WorkshopFreelancing";
import WorkshopDigitalAds from "./pages/WorkshopDigitalAds";
import WorkshopContentCreation from "./pages/WorkshopContentCreation";
import WorkshopResumePortfolio from "./pages/WorkshopResumePortfolio";

function App() {
  return (
    <div className="App">
      <BrowserRouter>
        <Routes>
          <Route path="/" element={<LandingPage />} />
          <Route path="/enrollment" element={<EnrollmentPage />} />
          <Route path="/enroll" element={<EnrollmentPage />} />
          <Route path="/courses/csdgpm" element={<CourseCSDGPM />} />
          <Route path="/courses/csdgpm-digital-growth-performance-marketing" element={<CourseCSDGPM />} />
          <Route path="/csdgpm-landing" element={<CSDGPMLandingPageNew />} />
          <Route path="/csdgpm-landing-old" element={<CSDGPMLandingPage />} />
          <Route path="/workshops/photo-editing-ai" element={<WorkshopPhotoEditing />} />
          <Route path="/workshops/video-editing-reels" element={<WorkshopVideoEditing />} />
          <Route path="/workshops/social-media-booster" element={<WorkshopSocialMedia />} />
          <Route path="/workshops/linkedin-personal-branding" element={<WorkshopLinkedIn />} />
          <Route path="/workshops/prompt-engineering" element={<WorkshopPromptEngineering />} />
          <Route path="/workshops/canva-design-secrets" element={<WorkshopCanvaDesign />} />
          <Route path="/workshops/freelancing-side-income" element={<WorkshopFreelancing />} />
          <Route path="/workshops/digital-ads-automation" element={<WorkshopDigitalAds />} />
          <Route path="/workshops/content-creation-mastery" element={<WorkshopContentCreation />} />
          <Route path="/workshops/resume-portfolio-builder" element={<WorkshopResumePortfolio />} />
        </Routes>
      </BrowserRouter>
    </div>
  );
}

export default App;