# Frontend-Backend Integration Contracts

## Current Implementation Status
✅ **Frontend**: Fully functional landing page with all sections
✅ **Backend**: Enrollment API implemented and connected
✅ **Database**: MongoDB storing enrollment requests
✅ **Integration**: Frontend-backend connected via axios

## Landing Page Architecture

### Implemented Frontend Structure
- **Technology**: React with Tailwind CSS & Shadcn UI
- **Styling**: Green-AI Design System (Professional, Clean)
- **Components**:
  - Hero Section with partnership branding
  - Industry Facts section (75% job transformation rate, 3.5M AI jobs, 40% salary increment)
  - About Partnership section
  - 5 Course Cards (Data Analytics, AI-ML, Prompt Engineering, Animation, Marketing)
  - Benefits showcase with 3 main benefits + 4 additional perks
  - FAQ Section with 8 comprehensive questions (Shadcn Accordion)
  - **Enrollment Form** with validation and backend integration
  - Footer with links and contact info

### Dynamic Content (Backend Integrated)
- **Enrollment Form**: Connected to backend API
  - Saves enrollment requests to MongoDB
  - Real-time form validation
  - Success/error notifications via Sonner toast
  - Automatic form reset on successful submission

## Future Backend Implementation Plan

### Phase 1: Course Management API (If Needed)
If dynamic course management is required in the future:

#### API Endpoints
```
GET /api/courses - Fetch all courses
POST /api/courses - Create new course (admin)
PUT /api/courses/:id - Update course (admin)
DELETE /api/courses/:id - Delete course (admin)
```

#### Course Model
```python
{
  "id": "string",
  "title": "string",
  "description": "string",
  "duration": "string",
  "level": "string",
  "image": "string (URL)",
  "icon_type": "string",
  "created_at": "datetime",
  "updated_at": "datetime"
}
```

### Phase 2: Enrollment/Contact Form (If Needed)
If user enrollment tracking is required:

#### API Endpoints
```
POST /api/enrollments - Submit enrollment request
GET /api/enrollments - Get all enrollments (admin)
```

#### Enrollment Model
```python
{
  "id": "string",
  "name": "string",
  "email": "string",
  "phone": "string",
  "course_interest": "string",
  "message": "string (optional)",
  "status": "pending|contacted|enrolled",
  "created_at": "datetime"
}
```

### Phase 3: Admin Dashboard (If Needed)
- View enrollment requests
- Manage course content
- Update partnership information

## Integration Notes

### When Backend is Implemented:
1. Replace hardcoded `courses` array in LandingPage.jsx with API call
2. Add enrollment form functionality to CTA buttons
3. Implement form validation using react-hook-form + zod
4. Add loading states and error handling
5. Add success notifications using Sonner toast

### Environment Variables Required:
- Frontend already has: `REACT_APP_BACKEND_URL` (configured)
- Backend already has: `MONGO_URL` (configured)

## Current Workflow
✅ User visits landing page
✅ Views course information (static)
✅ Clicks CTA buttons (currently no action - can be linked to external forms)
✅ Views partnership details
✅ Browses benefits

## Recommended Next Steps (If Backend Needed)
1. Confirm with client if enrollment tracking is needed
2. If yes, implement enrollment API first
3. Add form components to capture user interest
4. Implement email notifications (optional)
5. Create basic admin panel (optional)

---

**Note**: The current landing page is production-ready as a static informational site. Backend is only needed if dynamic content management or enrollment tracking is required.
