from pydantic import BaseModel, Field, EmailStr
from typing import Optional
from datetime import datetime
import uuid


class EnrollmentCreate(BaseModel):
    name: str
    email: EmailStr
    phone: str
    city: str
    course: str
    education: Optional[str] = None
    experience: Optional[str] = None
    message: Optional[str] = None
    # UTM Parameters for campaign tracking
    utm_source: Optional[str] = None
    utm_medium: Optional[str] = None
    utm_campaign: Optional[str] = None
    utm_content: Optional[str] = None
    utm_term: Optional[str] = None


class Enrollment(BaseModel):
    id: str = Field(default_factory=lambda: str(uuid.uuid4()))
    name: str
    email: EmailStr
    phone: str
    city: str
    course: str
    education: Optional[str] = None
    experience: Optional[str] = None
    message: Optional[str] = None
    # UTM Parameters for campaign tracking
    utm_source: Optional[str] = None
    utm_medium: Optional[str] = None
    utm_campaign: Optional[str] = None
    utm_content: Optional[str] = None
    utm_term: Optional[str] = None
    status: str = "pending"
    created_at: datetime = Field(default_factory=datetime.utcnow)

    class Config:
        json_schema_extra = {
            "example": {
                "name": "Rajesh Kumar",
                "email": "rajesh@example.com",
                "phone": "9876543210",
                "city": "Mumbai",
                "course": "Data Analytics",
                "education": "B.Tech Computer Science",
                "experience": "2 years in IT",
                "message": "Looking forward to learning data analytics",
                "utm_source": "google",
                "utm_medium": "cpc",
                "utm_campaign": "data_analytics_course",
                "utm_content": "banner_ad",
                "utm_term": "data_analytics_training",
                "status": "pending"
            }
        }
