from pydantic import BaseModel, Field, EmailStr
from typing import Optional
from datetime import datetime
import uuid


class CourseLeadCreate(BaseModel):
    name: str
    email: EmailStr
    phone: str
    city: Optional[str] = "Not provided"
    course: str
    message: Optional[str] = None
    lead_type: str = "course_inquiry"
    # UTM Parameters for campaign tracking
    utm_source: Optional[str] = None
    utm_medium: Optional[str] = None
    utm_campaign: Optional[str] = None
    utm_content: Optional[str] = None
    utm_term: Optional[str] = None


class CourseLead(BaseModel):
    id: str = Field(default_factory=lambda: str(uuid.uuid4()))
    name: str
    email: EmailStr
    phone: str
    city: Optional[str] = "Not provided"
    course: str
    message: Optional[str] = None
    lead_type: str = "course_inquiry"
    # UTM Parameters for campaign tracking
    utm_source: Optional[str] = None
    utm_medium: Optional[str] = None
    utm_campaign: Optional[str] = None
    utm_content: Optional[str] = None
    utm_term: Optional[str] = None
    status: str = "new"
    created_at: datetime = Field(default_factory=datetime.utcnow)

    class Config:
        json_schema_extra = {
            "example": {
                "name": "John Doe",
                "email": "john@example.com",
                "phone": "+1234567890",
                "country": "USA",
                "course": "CSDGPM",
                "message": "Interested in the course",
                "lead_type": "course_inquiry",
                "status": "new"
            }
        }
