from pydantic import BaseModel, Field, EmailStr
from typing import Optional
from datetime import datetime
import uuid

class BookingCreate(BaseModel):
    name: str
    email: EmailStr
    phone: str
    city: str
    promoCode: str
    originalPrice: float
    discountPercent: float
    finalPrice: float
    bookingDate: str

class Booking(BaseModel):
    id: str = Field(default_factory=lambda: str(uuid.uuid4()))
    name: str
    email: EmailStr
    phone: str
    city: str
    promoCode: str
    originalPrice: float
    discountPercent: float
    finalPrice: float
    bookingDate: datetime
    status: str = "confirmed"
    created_at: datetime = Field(default_factory=datetime.utcnow)
