# Email Notification Setup Guide

## Current Status ✅

Your application is **already configured** to send email notifications to **madhurkhera03@gmail.com** for:

1. **Enrollment Form Submissions** (from landing page)
2. **Course Inquiry Submissions** (from CSDGPM course page forms)
3. **Chatbot Lead Submissions** (from chatbot conversations)

**Currently:** All email notifications are being **logged to the backend console** because SMTP is not configured.

You can see these notifications in the backend logs:
```bash
tail -f /var/log/supervisor/backend.err.log
```

---

## How to Enable Actual Email Sending

To send real emails to madhurkhera03@gmail.com, you need to configure SMTP settings. Here are the options:

### Option 1: Use Gmail SMTP (Recommended for Testing)

1. **Go to your Gmail account** (madhurkhera03@gmail.com)

2. **Enable 2-Factor Authentication** (if not already enabled)
   - Go to: https://myaccount.google.com/security
   - Turn on 2-Step Verification

3. **Generate an App Password**
   - Go to: https://myaccount.google.com/apppasswords
   - Select "Mail" and "Other (Custom name)"
   - Enter: "AI School Backend"
   - Click "Generate"
   - **Copy the 16-character password** (it will look like: "abcd efgh ijkl mnop")

4. **Update the backend .env file** (`/app/backend/.env`):
   ```env
   SMTP_HOST="smtp.gmail.com"
   SMTP_PORT="587"
   SMTP_USERNAME="madhurkhera03@gmail.com"
   SMTP_PASSWORD="your-16-character-app-password-here"
   SMTP_FROM_EMAIL="madhurkhera03@gmail.com"
   ```

5. **Restart the backend**:
   ```bash
   sudo supervisorctl restart backend
   ```

6. **Test email sending**:
   ```bash
   curl -X POST http://localhost:8001/api/test-email
   ```

---

### Option 2: Use SendGrid (Recommended for Production)

SendGrid provides 100 free emails per day.

1. **Sign up at**: https://sendgrid.com/

2. **Create an API Key**:
   - Go to Settings > API Keys
   - Create a new API key with "Full Access"
   - Copy the API key

3. **Install SendGrid Python package**:
   ```bash
   cd /app/backend
   pip install sendgrid
   pip freeze > requirements.txt
   ```

4. **Update backend code** to use SendGrid API (alternative to SMTP)

5. **Or configure SMTP settings**:
   ```env
   SMTP_HOST="smtp.sendgrid.net"
   SMTP_PORT="587"
   SMTP_USERNAME="apikey"
   SMTP_PASSWORD="your-sendgrid-api-key"
   SMTP_FROM_EMAIL="noreply@aischoolforall.com"
   ```

---

### Option 3: Use AWS SES (Best for Production)

AWS Simple Email Service is highly reliable and cost-effective.

1. **Sign up for AWS**: https://aws.amazon.com/ses/

2. **Verify your email** (madhurkhera03@gmail.com)

3. **Get SMTP credentials** from AWS SES console

4. **Configure .env**:
   ```env
   SMTP_HOST="email-smtp.us-east-1.amazonaws.com"
   SMTP_PORT="587"
   SMTP_USERNAME="your-aws-smtp-username"
   SMTP_PASSWORD="your-aws-smtp-password"
   SMTP_FROM_EMAIL="noreply@aischoolforall.com"
   ```

---

## Email Notification Details

### When Emails Are Sent

**1. Enrollment Form (Landing Page)**
- **Trigger**: User submits enrollment form
- **To**: madhurkhera03@gmail.com
- **Subject**: "New Enrollment: [Course Name]"
- **Content**: Name, Email, Phone, Course, Timestamp

**2. Course Lead Form (CSDGPM Page)**
- **Trigger**: User submits course inquiry form
- **To**: madhurkhera03@gmail.com
- **Subject**: "New Course Inquiry: [Course Name]"
- **Content**: Name, Email, Phone, Country, Course, Message, Timestamp

**3. Chatbot Lead Capture**
- **Trigger**: Chatbot collects name, email, phone
- **To**: madhurkhera03@gmail.com
- **Subject**: "New Course Inquiry: CSDGPM"
- **Content**: Name, Email, Phone, Country (Not provided), Course, Timestamp

---

## Testing Email Notifications

### Test Endpoint
```bash
curl -X POST http://localhost:8001/api/test-email
```

### Test Enrollment Form
```bash
curl -X POST http://localhost:8001/api/enrollments \
  -H "Content-Type: application/json" \
  -d '{
    "name": "Test Student",
    "email": "test@example.com",
    "phone": "+1-555-123-4567",
    "course": "CSDGPM"
  }'
```

### Test Course Lead Form
```bash
curl -X POST http://localhost:8001/api/course-leads \
  -H "Content-Type: application/json" \
  -d '{
    "name": "Test User",
    "email": "test@example.com",
    "phone": "+1-555-123-4567",
    "course": "CSDGPM"
  }'
```

### Check Backend Logs
```bash
# See all logs
tail -f /var/log/supervisor/backend.err.log

# See only email notifications
tail -f /var/log/supervisor/backend.err.log | grep -A 20 "Email\|SMTP"
```

---

## Current Behavior (Without SMTP Configured)

✅ **All functionality works correctly**
✅ **All form submissions are saved to MongoDB**
✅ **All email notifications are logged to backend console**
✅ **You can see all notifications in backend logs**

The only difference is that actual emails are not sent to inbox - they're logged instead.

---

## Production Recommendations

1. **Use SendGrid or AWS SES** (more reliable than Gmail)
2. **Set up email verification** (SPF, DKIM, DMARC records)
3. **Use a professional from address** (noreply@aischoolforall.com)
4. **Monitor email delivery** through service dashboards
5. **Set up email templates** for better formatting
6. **Add auto-responder** to send confirmation to students

---

## Need Help?

If you need assistance setting up email sending, please share:
1. Which email service you'd like to use (Gmail, SendGrid, AWS SES, etc.)
2. Any error messages you encounter
3. Your Gmail settings (if using Gmail SMTP)

**Note**: Never share actual passwords in chat. Use environment variables only.
